package gov.va.med.esr.common.persistent.person;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.math.BigDecimal;
import java.util.List;


public interface MECPeriodDAO extends DAOOperations {

	/**
	 * Looks up all MEC Period record by person_id.
	 * @param person_id The person_id to lookup
	 * @return
	 * @throws DAOException
	 */
	public List getByPersonId(BigDecimal personId) throws DAOException;

	/**
	 * Get Records to submit for cal year
	 * @param calendarYear The year to search
	 * @param batchSize The rownum limit of the batch to return
	 * @return
	 * @throws DAOException
	 */
	public List getMECRecordsToProcess(String calendarYear, String batchSize) throws DAOException;

	public List getMECPeriodByDate(BigDecimal personId, String statusDate) throws DAOException;


}
