package gov.va.med.esr.common.persistent.person;

import gov.va.med.fw.validation.ValidationMessages;
import org.aopalliance.intercept.MethodInvocation;
import gov.va.med.esr.common.model.person.Person;

/**
 * 
 * @author DNS   ruizc
 *
 */
public class InsuranceSubmittedAdvice extends PersonSubmittedAdvice {
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Object result = invocation.proceed();
		// CCR 12062 insurance needs special handling		
		if(result instanceof ValidationMessages) {
			Person person = this.getPersonArgumentIfAny(invocation.getArguments());
			if (person != null) {
				// Since updateInsurance does not return a Person,
				// get the result from args 
				processEntitySubmitted((Person)person, invocation.getArguments());				
			}
		}
		return result;
	}
}
