/********************************************************************
 * Copyright  2004-2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.person;

// Java Classes
import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

/**
 * This interface defines various DAO methods for searching and retrieving HealthCareProvider objects.
 */
public interface HealthCareProviderDAO extends DAOOperations
{
    /**
     * Find a HealthCareProvider object given the practitionerId.
     *
     * @param practitionerId The practitionerId
     *
     * @return 
     * @throws DAOException if there was an error trying to find the search results.
     */
    public HealthCareProvider findByPractitionerID(String practitionerId) throws DAOException;
 

}