package gov.va.med.esr.common.persistent.person;

import java.util.List;

import org.hibernate.lob.SerializableClob;

import gov.va.med.esr.common.model.person.EnrollmentApplication;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;


public interface EnrollmentApplicationDAO extends DAOOperations {
	
	public EnrollmentApplication getByIcn(String icn) throws DAOException;
	
	public SerializableClob getInProcessPersonXmlByIcn(String icn) throws DAOException;
	
	
	/**
	 * get the list of application status code , by icn, and returns a Person object.
	 * @param icn The icn to lookup
	 * @return A string of application status code.
	 */
	public List getApplicationStatusCodeListByIcn(String icn) throws DAOException;

}
