package gov.va.med.esr.common.persistent.person;

import gov.va.med.esr.common.model.person.ApplicationInProcess;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.util.List;

public interface ApplicationInProcessDAO extends DAOOperations {

	/**
	 * Looks up a person by ssn and returns a list of Person objects.  This list may be empty.
	 * @param ssn The ssn to lookup
	 * @return A list of Person objects.
	 * @throws DAOException
	 */
	//public List getBySsn(String ssn) throws DAOException;

	/**
	 * Looks up ApplicationInProcess record by icn.
	 * @param icn The icn to lookup
	 * @return
	 * @throws DAOException
	 */
	public ApplicationInProcess getByIcn(String icn) throws DAOException;
	
	/**
	 * Looks up a person In-Process or New Application, by ICN. 
	 * @param icn The icn to lookup
	 * @return
	 * @throws DAOException
	 */
	public Person getInProcessPersonByIcn(String icn) throws DAOException;
	
	/**
	 * Retrieve a person that has Complete status by ICN.
	 * 
	 * @param icn
	 * @return
	 * @throws DAOException
	 */
	public Person getCompletedPersonByIcn(String icn) throws DAOException; 	

}
