package gov.va.med.esr.common.persistent.messaging.hibernate;

import gov.va.med.esr.common.model.messaging.SeedingLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.messaging.SeedingLogEntryDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class SeedingLogEntryDAOImpl extends GenericDAOImpl implements SeedingLogEntryDAO {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4381743890002053737L;
	
	public SeedingLogEntry getById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_IDENTIFIER,PARAM_IDENTIFIER,identifier );

            // Should only return one value
            return results.isEmpty() ? null : (SeedingLogEntry) results.get(0);
        } 
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the seeding log entry by identifier", e);
        }
    }
	
	/**
	 * @see gov.va.med.esr.common.persistent.messaging.MessageLogEntryDAO#find(gov.va.med.esr.common.model.person.Person)
	 */
	public List find(Person person) throws DAOException
    {
        try
        {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam(FIND_BY_PERSON,
                    PARAM_PERSON_ID, (BigDecimal) person.getEntityKey()
                            .getKeyValue());
            return results;
        } catch (DataAccessException e)
        {
            throw new DAOException("Failed to load the message log entries", e);
        }
    }
	
	public List findPersonId(BigDecimal personId) throws DAOException
    {
        try
        {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam(FIND_BY_PERSON,
                    PARAM_PERSON_ID, (BigDecimal) personId);
            return results;
        } catch (DataAccessException e)
        {
            throw new DAOException("Failed to load the message log entries", e);
        }
    }
	
	

}
