/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.messaging.hibernate;

// Java Classes
import java.math.BigDecimal;
import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import gov.va.med.esr.common.model.messaging.MsdsMessageLogEntry;
import gov.va.med.esr.common.model.messaging.MsdsMessagePayloadEntry;
import gov.va.med.esr.common.persistent.messaging.MsdsMessagePayloadEntryDAO;


/**
 * Provides methods to retrieve a message payload entry entity
 *
 */
public class MsdsMessagePayloadEntryDAOImpl extends GenericDAOImpl implements MsdsMessagePayloadEntryDAO {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4381743890002053737L;

    public MsdsMessagePayloadEntry getById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_IDENTIFIER,PARAM_IDENTIFIER,identifier );

            // Should only return one value
            return results.isEmpty() ? null : (MsdsMessagePayloadEntry) results.get(0);
        } 
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message payload entry by identifier", e);
        }
    }    
    
	
	/**
	 * @see gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO#find(gov.va.med.esr.common.model.person.Person)
	 */
	public MsdsMessagePayloadEntry find(MsdsMessageLogEntry msdsMessageLogEntry) throws DAOException
    {
        try
        {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam(FIND_BY_MSG_LOG_ID,
            		PARAM_MSG_LOG_ID, (BigDecimal) msdsMessageLogEntry.getEntityKey()
                            .getKeyValue());
         // Should only return one value
            return results.isEmpty() ? null : (MsdsMessagePayloadEntry) results.get(0);
        } catch (DataAccessException e)
        {
            throw new DAOException("Failed to load the message payload entry", e);
        }
    }
	
}