/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.messaging.hibernate;

// Java Classes
import java.math.BigDecimal;
import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import gov.va.med.esr.common.model.messaging.MsdsMessageLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO;


/**
 * Provides methods to retrieve a message log entry entity
 *
 * Project: Common</br>
 * Created on: 9:47:22 AM </br>
 *
 * @author DNS   LEV, Martin Francisco
 */
public class MsdsMessageLogEntryDAOImpl extends GenericDAOImpl implements MsdsMessageLogEntryDAO {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4381743890002053737L;

    public MsdsMessageLogEntry getById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_IDENTIFIER,PARAM_IDENTIFIER,identifier );

            // Should only return one value
            return results.isEmpty() ? null : (MsdsMessageLogEntry) results.get(0);
        } 
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry by identifier", e);
        }
    }    
    
	/**
	 * @see gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO#getByControlId(java.lang.String)
	 */
	public MsdsMessageLogEntry getByControlId(BigDecimal controlIdentifier) throws DAOException {
		try {
			HibernateTemplate tpl = this.getHibernateTemplate();
			List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_CONTROL_IDENTIFIER, 
																			  PARAM_CONTROL_IDENTIFIER,
																			  controlIdentifier );

			// Should only return one value
			return results.isEmpty() ? null : (MsdsMessageLogEntry) results.get(0);
		} 
		catch (DataAccessException e) {
			throw new DAOException("Failed to get the message log entry", e);
		}
	}

	
	
	/**
	 * @see gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO#find(gov.va.med.esr.common.model.person.Person)
	 */
	public List find(Person person) throws DAOException
    {
        try
        {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam(FIND_BY_PERSON,
                    PARAM_PERSON_ID, (BigDecimal) person.getEntityKey()
                            .getKeyValue());
            return results;
        } catch (DataAccessException e)
        {
            throw new DAOException("Failed to load the message log entries", e);
        }
    }
	
	/**
	 * @see gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO#findSiteLastTransmittedMsg(gov.va.med.fw.model.EntityKey)
	 */
	public MsdsMessageLogEntry findClockSetEntry(EntityKey personId) throws DAOException
	{
		try {
			
			HibernateTemplate tpl = this.getHibernateTemplate();
			
			String[] params = new String[]{ PARAM_PERSON_ID};
			Object[] values = new Object[]{ (BigDecimal)personId.getKeyValue()};
			List results = tpl.findByNamedQueryAndNamedParam( 
					FIND_CLOCK_SET_Query, params, values );
			// Should only return one value
			return results.isEmpty() ? null : (MsdsMessageLogEntry) results.get(0);
		} 
		catch (DataAccessException e) {
			throw new DAOException("Failed to load the message log entries", e);
		}		
	}
	
	public Integer findCompleteCount(EntityKey personId) throws DAOException 
	{
		try {

			HibernateTemplate tpl = this.getHibernateTemplate();

			String[] params = new String[]{ PARAM_PERSON_ID};
			Object[] values = new Object[]{ (BigDecimal)personId.getKeyValue()};
			List results = tpl.findByNamedQueryAndNamedParam( 
					FIND_COMPLETE_COUNT, params, values );
			// Should only return one value
			return ((Integer) (results.iterator().next()));
		} 
		catch (DataAccessException e) {
			throw new DAOException("Failed to load the message log entries", e);
		}		
		
		
	}
	
	
}