package gov.va.med.esr.common.persistent.messaging.hibernate;

import gov.va.med.esr.common.model.messaging.MsdsErrorLogEntry;
import gov.va.med.esr.common.persistent.messaging.MsdsErrorLogEntryDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class MsdsErrorLogEntryDAOImpl extends GenericDAOImpl implements MsdsErrorLogEntryDAO {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4381743890002053737L;
	
	public MsdsErrorLogEntry getById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_IDENTIFIER,PARAM_IDENTIFIER,identifier );

            // Should only return one value
            return results.isEmpty() ? null : (MsdsErrorLogEntry) results.get(0);
        } 
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the msdsErrorLogEntry log entry by identifier", e);
        }
    }	

}
