package gov.va.med.esr.common.persistent.messaging.hibernate;

// Java Classes
import java.math.BigDecimal;
import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import gov.va.med.esr.common.model.messaging.IrsTransmissionLogEntry;
import gov.va.med.esr.common.persistent.messaging.IrsTransmissionLogEntryDAO;


/**
 * Provides methods to retrieve a message log entry entity
 *
 * Project: Common</br>
 * Created 9/28/2015 </br>
 *
 * @author DNS   faulkj
 */
public class IrsTransmissionLogEntryDAOImpl extends GenericDAOImpl implements IrsTransmissionLogEntryDAO {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4381743890112053737L;

	@Transactional
    public IrsTransmissionLogEntry getById(BigDecimal identifier) throws DAOException {

    	IrsTransmissionLogEntry result = null;

    	try {

        	HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_IDENTIFIER,PARAM_IDENTIFIER,identifier );

            // Should only return one value

            result = (results.isEmpty() ? null : (IrsTransmissionLogEntry) results.get(0));

        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry by identifier", e);
        }

        return result;
    }
	@Transactional
    public IrsTransmissionLogEntry getByReceiptId(String receiptId) throws DAOException {
    	 try {
             HibernateTemplate tpl = this.getHibernateTemplate();
             List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_RECEIPT_ID,PARAM_RECEIPT,receiptId );

             // Should only return one value
             return results.isEmpty() ? null : (IrsTransmissionLogEntry) results.get(0);
         }
         catch (DataAccessException e) {
             throw new DAOException("Failed to get the message log entry by receiptId", e);
         }
    }

    public List getFailedBatchTransmissions() throws DAOException {
    	 try {
             HibernateTemplate tpl = this.getHibernateTemplate();
             List results = tpl.findByNamedQuery( FIND_FAILURES);

             // Should only return one value
             return results;
         }
         catch (DataAccessException e) {
             throw new DAOException("Failed to get the failed transmission list", e);
         }
    }

}