/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.messaging;

// Java classes
import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

import gov.va.med.esr.common.model.messaging.SeedingLogEntry;
import gov.va.med.esr.common.model.messaging.MessageLogEntryLite;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.MessageLogCriteria;

/**
 * Provides methods to retrieve a message log entry entity
 *
 * Project: Common</br>
 * Created on: 9:47:22 AM </br>
 *
 * @author DNS   LEV, Martin Francisco
 */
public interface SeedingLogEntryDAO extends DAOOperations {
	
    /**
     * A key to look up a a named query FIND_BY_IDENTIFIER
     */
    public static final String FIND_BY_IDENTIFIER = "seedingLogEntryQuery_Identifier";    
    	
    /**
     * A name of a param PARAM_IDENTIFIER
     */
    public static final String PARAM_IDENTIFIER = "identifier";   
    
	/**
	 * A key to look up a a named query NAMED_QUERY_FIND_BY_PERSON
	 */
	public static final String FIND_BY_PERSON = "seedingLogEntryQuery_FindByPerson";	
	
	/**
	 * Query Parameter person id
	 */
	public static final String PARAM_PERSON_ID = "personId"; 	
	
	
	public static final String PARAM_MESSAGE_STATUS= "messageStatus";	
		
	
    /**
     * Gets the message log entry for the message with the specified identifier.
     * 
     * @param controlIdentifier The identifier.
     * @return The message log entry for the message with the specified identifier.
     * @throws DAOException Thrown when a persistence exception occurs.
     */
    public SeedingLogEntry getById(BigDecimal identifier) throws DAOException;  
		
	/**
	 * Finds the message log entries for a person.
	 * 
	 * @param person The person whose message log entries will be returned.
	 * @return A list of message log entries for the specified person.
	 * @throws DAOException Thrown when a persistence exception occurs.
	 */
	public List find(Person person) throws DAOException; 
	
	public List findPersonId(BigDecimal personId) throws DAOException; 
    
    
	
	
	
	
}