/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.messaging;

// Java classes
import java.math.BigDecimal;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import gov.va.med.esr.common.model.messaging.MsdsMessageLogEntry;
import gov.va.med.esr.common.model.messaging.MsdsMessagePayloadEntry;


/**
 * Provides methods to retrieve a MSDS message payload entry entity
 *
 */
public interface MsdsMessagePayloadEntryDAO extends DAOOperations {
	
    /**
     * A key to look up a a named query FIND_BY_IDENTIFIER
     */
    public static final String FIND_BY_IDENTIFIER = "MsdsMessagePayloadEntryQuery_Identifier"; 
    	
    /**
     * A name of a param PARAM_IDENTIFIER
     */
    public static final String PARAM_IDENTIFIER = "identifier";
    	
	/**
	 * A key to look up a a named query NAMED_QUERY_FIND_BY_MSG_LOG_ID
	 */
	public static final String FIND_BY_MSG_LOG_ID = "MsdsMessagePayloadEntryQuery_FindByMsdsMessageLogId";
	
	/**
	 * Query Parameter msg log id
	 */
	public static final String PARAM_MSG_LOG_ID = "msdsMessageLogId";
	
    /**
     * Gets the msds message payload entry for the message with the specified identifier.
     * 
     * @param identifier The identifier.
     * @return The message payload entry for the message with the specified identifier.
     * @throws DAOException Thrown when a persistence exception occurs.
     */
    public MsdsMessagePayloadEntry getById(BigDecimal identifier) throws DAOException;   
	
	/**
	 * Finds the message payload entry for a msg log id.
	 * 
	 * @param msdsMessageLogEntry 
	 * @return A message payload entry for the specified msg log id.
	 * @throws DAOException Thrown when a persistence exception occurs.
	 */
	public MsdsMessagePayloadEntry find(MsdsMessageLogEntry msdsMessageLogEntry) throws DAOException;  
	
}