/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.messaging;

// Java classes
import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.MsdsMessageLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.MessageLogCriteria;

/**
 * Provides methods to retrieve a message log entry entity
 *
 * Project: Common</br>
 * Created on: 9:47:22 AM </br>
 *
 * @author DNS   LEV, Martin Francisco
 */
public interface MsdsMessageLogEntryDAO extends DAOOperations {
	
    /**
     * A key to look up a a named query FIND_BY_IDENTIFIER
     */
    public static final String FIND_BY_IDENTIFIER = "MsdsMessageLogEntryQuery_Identifier"; 
    
	/**
	 * A key to look up a a named query FIND_BY_CONTROL_IDENTIFIER
	 */
	public static final String FIND_BY_CONTROL_IDENTIFIER = "MsdsMessageLogEntryQuery_ControlIdentifier";	
	
    /**
     * A name of a param PARAM_IDENTIFIER
     */
    public static final String PARAM_IDENTIFIER = "identifier";
    
	/**
	 * A name of a param PARAM_CONTROL_IDENTIFIER
	 */
	public static final String PARAM_CONTROL_IDENTIFIER = "controlIdentifier";
	
	public static final String PARAM_STATION_NUMBER = "stationNumber";	
	
	/**
	 * A key to look up a a named query NAMED_QUERY_FIND_BY_PERSON
	 */
	public static final String FIND_BY_PERSON = "MsdsMessageLogEntryQuery_FindByPerson";
	
	/**
	 * Query to lookup the facility that sent the recent message
	 */
	public static final String FIND_CLOCK_SET_Query = "MsdsmessageLogEntryQuery_clock";
	
	public static final String FIND_COMPLETE_COUNT = "MsdsMessageLogEntryQuery_Complete";
	/**
	 * Query Parameter person id
	 */
	public static final String PARAM_PERSON_ID = "personId";
	
	public static final String PARAM_RETRANSMISSION_COUNT = "retransmissionCount";
	
	public static final String PARAM_RETRANSMISSION_WAIT_PERIOD= "retransmissionWaitPeriod";
	
	public static final String PARAM_MESSAGE_STATUS= "messageStatus";
	
	public static final String PARAM_MESSAGE_TYPE= "messageType";
	
    /**
     * Gets the message log entry for the message with the specified identifier.
     * 
     * @param controlIdentifier The identifier.
     * @return The message log entry for the message with the specified identifier.
     * @throws DAOException Thrown when a persistence exception occurs.
     */
    public MsdsMessageLogEntry getById(BigDecimal identifier) throws DAOException;   
 
    
	/**
	 * Gets the message log entry for the message with the specified control
	 * identifier.
	 * 
	 * @param controlIdentifier The control identifier.
	 * @return The message log entry for the message with the specified control identifier.
	 * @throws DAOException Thrown when a persistence exception occurs.
	 */
	public MsdsMessageLogEntry getByControlId(BigDecimal controlIdentifier) throws DAOException;	
	
	/**
	 * Finds the message log entries for a person.
	 * 
	 * @param person The person whose message log entries will be returned.
	 * @return A list of message log entries for the specified person.
	 * @throws DAOException Thrown when a persistence exception occurs.
	 */
	public List find(Person person) throws DAOException;  
	
	/**
	 * Find the Facility from whih the last message has been received and successfully processed
	 * 
	 * @param personId
	 * @return
	 * @throws DAOException
	 */
	public MsdsMessageLogEntry findClockSetEntry(EntityKey personId) throws DAOException; 
	
	/**
	 * Find the Facility from whih the last message has been received and successfully processed
	 * 
	 * @param personId
	 * @return
	 * @throws DAOException
	 */
	public Integer findCompleteCount(EntityKey personId) throws DAOException;
	
}