/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.messaging;

// Java classes
import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

import gov.va.med.esr.common.model.messaging.MsdsErrorLogEntry;
import gov.va.med.esr.common.model.messaging.SeedingLogEntry;
import gov.va.med.esr.common.model.messaging.MessageLogEntryLite;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.MessageLogCriteria;

/**
 * Provides methods to retrieve a message log entry entity
 *
 * Project: Common</br>
 * Created on: 9:47:22 AM </br>
 *
 * @author DNS   LEV, Martin Francisco
 */
public interface MsdsErrorLogEntryDAO extends DAOOperations {
	
    /**
     * A key to look up a a named query FIND_BY_IDENTIFIER
     */
    public static final String FIND_BY_IDENTIFIER = "msdsErrorLogEntryQuery_Identifier";    
    	
    /**
     * A name of a param PARAM_IDENTIFIER
     */
    public static final String PARAM_IDENTIFIER = "identifier";       
	
		
	
    /**
     * Gets the message log entry for the message with the specified identifier.
     * 
     * @param controlIdentifier The identifier.
     * @return The message log entry for the message with the specified identifier.
     * @throws DAOException Thrown when a persistence exception occurs.
     */
    public MsdsErrorLogEntry getById(BigDecimal identifier) throws DAOException;  
		
	
    
    
	
	
	
	
}