package gov.va.med.esr.common.persistent.messaging;

// Java classes
import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import gov.va.med.esr.common.model.messaging.IrsTransmissionLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;


public interface IrsTransmissionLogEntryDAO extends DAOOperations {

    /**
     * A key to look up a a named query FIND_BY_IDENTIFIER
     */
    public static final String FIND_BY_IDENTIFIER = "IrsTransmissionLogEntryQuery_Identifier";
    public static final String FIND_FAILURES = "IrsTransmissionLogEntryQuery_findFailures";
    public static final String FIND_BY_RECEIPT_ID = "IrsTransmissionLogEntryQuery_ReceiptId";

    /**
     * A name of a param PARAM_IDENTIFIER
     */
    public static final String PARAM_IDENTIFIER = "identifier";

    public static final String PARAM_RECEIPT = "receiptId";
	public static final String PARAM_TRANSMISSION_STATUS= "transmissionStatus";

    /**
     * Gets the message log entry for the message with the specified identifier.
     *
     * @param controlIdentifier The identifier.
     * @return The message log entry for the message with the specified identifier.
     * @throws DAOException Thrown when a persistence exception occurs.
     */
    public IrsTransmissionLogEntry getById(BigDecimal identifier) throws DAOException;

    public List getFailedBatchTransmissions() throws DAOException;

    public IrsTransmissionLogEntry getByReceiptId(String receiptId) throws DAOException;


}