package gov.va.med.esr.common.persistent.messaging;

// Java classes
import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;


public interface IrsTransmissionLogDetailEntryDAO extends DAOOperations {

    public static final String FIND_BY_IDENTIFIER = "IrsTransmissionLogDetailEntryQuery_Identifier";

    public static final String FIND_BY_PERSON_ID = "IrsTransmissionLogDetailEntryQuery_findByPersonId";

    public static final String FIND_MOST_RECENT = "IrsTransmissionLogDetailEntryQuery_findMostRecentEntry";

    public static final String FIND_CORRECTION_YEARS = "IrsTransmissionLogDetailEntryQuery_findAllowedCorrectionYears";

    public static final String FIND_FAILURES = "IrsTransmissionLogDetailEntryQuery_findFailures";

    public static final String FIND_ORIGINAL_FOR_YEAR =  "IrsTransmissionLogDetailEntryQuery_findOriginalForYear";

    public static final String PARAM_IDENTIFIER = "identifier";

	public static final String PARAM_PERSON_ID = "personId";

	public static final String PARAM_TAX_YEAR = "taxYear";

	public static final String PARAM_IEN = "ien";

    /**
     * Gets the message log entry for the message with the specified identifier.
     *
     * @param controlIdentifier The identifier.
     * @return The message log entry for the message with the specified identifier.
     * @throws DAOException Thrown when a persistence exception occurs.
     */
    public IrsTransmissionLogDetailEntry getById(BigDecimal identifier) throws DAOException;

    public List<IrsTransmissionLogDetailEntry> findByPersonId(EntityKey personId) throws DAOException;

    public IrsTransmissionLogDetailEntry findMostRecentEntry(PersonEntityKey personId, String taxYear) throws DAOException;

    public List<IrsTransmissionLogDetailEntry> findAllowedCorrectionYears(EntityKey personId) throws DAOException;

    public List<IrsTransmissionLogDetailEntry> getFailedPersonTransmissions() throws DAOException;

    public IrsTransmissionLogDetailEntry findOriginalForYear(String ien, String taxYear) throws DAOException;


}