package gov.va.med.esr.common.persistent.lookup.hibernate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.persistent.lookup.VAFacilityDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
/**
 * 
  */
public class VAFacilityDAOImpl extends LookupsDAOImpl implements VAFacilityDAO
{
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 750952748836339280L;
	
	private String queryGetById = null;
    
    /**
     * Get facility by Id
     * Returns null if no match is.
     * 
     * @return 
     */    
	public VAFacility getById(BigDecimal identifier) throws DAOException
    {
        try
        {
    		Map contextData = new HashMap();
    		contextData.put("Id", identifier);				
     		HibernateCallback callback = new AbstractDAOAction(contextData) { 
    			public Object execute(Session session) {
    	            Query query = session.getNamedQuery(queryGetById);

     	           	query.setBigDecimal("Id", (BigDecimal)getContextData().get("Id"));
     	           
    	            // Use caching if enabled
    	            if (isCacheQuery())
    	            {
    	                query.setCacheable(true);
    	                query.setCacheRegion(getCacheRegion());
    	            }
    	            return query.setMaxResults(1).uniqueResult();    				
    			}
    		};
    		return (VAFacility) this.getHibernateTemplate().execute(callback);    		
        }
        catch(HibernateException e)
        {
            throw new DAOException("Failed to get VAFacility by Id.", e);
        }
    }
 
    
    /**
     * @return Returns the queryGetById.
     */
    public String getQueryGetById()
    {
        return queryGetById;
    }
    /**
     * @param queryGetById The queryGetById to set.
     */
    public void setQueryGetById(
            String queryGetById)
    {
        this.queryGetById = queryGetById;
    }
}
