package gov.va.med.esr.common.persistent.lookup.hibernate;

import java.util.HashMap;
import java.util.Map;

import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.persistent.lookup.StateDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
/**
 * DAO implementation for State
 * 
 * @author Rajiv Patnaik
 * Created on Nov 3, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public class StateDAOImpl extends LookupsDAOImpl implements StateDAO
{
    private static final long serialVersionUID = -7086520428025810712L;
    
    private String queryNameGetByCode = null;
    private String queryNameGetByName = null;
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.lookup.StateDAO#getStateByCode(java.lang.String)
     */
    public State getStateByCode(String code) throws DAOException
    {
        try
        {
    		Map contextData = new HashMap();
    		contextData.put("code", code);				        		        	
    		HibernateCallback callback = new AbstractDAOAction(contextData) { 
    			public Object execute(Session session) {
    	            // Get the named query
    	            Query query = session.getNamedQuery(queryNameGetByCode);

    	            query.setString("code", (String) getContextData().get("code"));

    	            // Use caching if enabled
    	            if (isCacheQuery())
    	            {
    	                query.setCacheable(true);
    	                query.setCacheRegion(getCacheRegion());
    	            }
    	            return query.setMaxResults(1).uniqueResult();    				
    			}    			
   			};
   			return (State) this.getHibernateTemplate().execute(callback);
        }
        catch(HibernateException e)
        {
            throw new DAOException("Failed to get State by name.", e);
        }
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.persistent.lookup.StateDAO#getStateByName(java.lang.String)
     */
    public State getStateByName(String name) throws DAOException
    {
        try
        {
    		Map contextData = new HashMap();
    		contextData.put("name", name);				        		        	
    		HibernateCallback callback = new AbstractDAOAction(contextData) { 
    			public Object execute(Session session) {
    	            // Get the named query
    	            Query query = session.getNamedQuery(queryNameGetByName);

    	            // Set the filter on zip code
    	            query.setString("name", (String) getContextData().get("name"));

    	            // Use caching if enabled
    	            if (isCacheQuery())
    	            {
    	                query.setCacheable(true);
    	                query.setCacheRegion(getCacheRegion());
    	            }
    	            return query.setMaxResults(1).uniqueResult();    				
    			}
    		};
    		return (State) this.getHibernateTemplate().execute(callback);
        }
        catch(HibernateException e)
        {
            throw new DAOException("Failed to get State by name.", e);
        }
    }
    
    /**
     * @return Returns the queryNameGetByCode.
     */
    public String getQueryNameGetByCode()
    {
        return queryNameGetByCode;
    }
    /**
     * @param queryNameGetByCode The queryNameGetByCode to set.
     */
    public void setQueryNameGetByCode(String queryNameGetByCode)
    {
        this.queryNameGetByCode = queryNameGetByCode;
    }
    

    /**
     * @return Returns the queryNameGetByName.
     */
    public String getQueryNameGetByName()
    {
        return queryNameGetByName;
    }
    /**
     * @param queryNameGetByName The queryNameGetByName to set.
     */
    public void setQueryNameGetByName(String queryNameGetByName)
    {
        this.queryNameGetByName = queryNameGetByName;
    }
    
}
