/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.lookup;

// Java classes
import java.util.List;

// Library classes

// Framework classes
import gov.va.med.fw.persistent.DAOException;

// ESR classes
import gov.va.med.esr.common.model.lookup.ZipCode;

/**
 * This class is the DAO for Zip Codes.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public interface ZipCodeDAO extends LookupsDAO
{
    /**
     * Gets a zip code object that has only the following attributes filled in:
     *
     * ZipCode.id
     * ZipCode.zipCode
     * ZipCode.state.name
     * ZipCode.cities.name
     * ZipCode.county.name
     *
     * @param code The zip code to get
     * @return The zip code object
     * @throws DAOException if there were any problems.
     */
    public ZipCode getPartialZipCodeByCode(String code) throws DAOException;

    /**
     * Gets a list of zip code objects that has only the following attributes filled in:
     * <p>
     * ZipCode.id
     * ZipCode.code
     * <p>
     * If no records are found, an empty list is returned.
     *
     * @param cityName The name of the city to query on
     * @param stateCode The state code to query on
     *
     * @return The zip code object
     * @throws DAOException if there were any problems.
     */
    public List getPartialZipCodeByCityState(String cityName, String stateCode) throws DAOException;

    /**
     * Gets a list of zip code objects that has only the following attributes filled in:
     * <p>
     * ZipCode.id
     * ZipCode.code
     * <p>
     * If no records are found, an empty list is returned.
     *
     * @param cityName The name of the city to query on
     *
     * @return The zip code object
     * @throws DAOException if there were any problems.
     */
    public List getPartialZipCodeByCity(String cityName) throws DAOException;
}