package gov.va.med.esr.common.persistent.lookup;

import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.fw.persistent.DAOException;

/**
 * DAO for State. Defines methods to lookup State based on specific queries.
 * 
 * @author Rajiv Patnaik
 * Created on Nov 3, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public interface StateDAO extends LookupsDAO
{
    /**
     * Gets the State object based on the code. 
     * Returns null if the name does not exist,
     *  
     * @param name
     * @return State
     * @throws DAOException
     */
    public State getStateByCode(String name) throws DAOException;
    
    /**
     * Gets the State object based on the name. 
     * Returns null if the name does not exist,
     *  
     * @param name
     * @return State
     * @throws DAOException
     */
    public State getStateByName(String name) throws DAOException;
}
