package gov.va.med.esr.common.persistent.lookup;

import gov.va.med.esr.common.model.lookup.County;
import gov.va.med.fw.persistent.DAOException;
/**
 * Interface to get County based on queries 
 *  
 * @author Rajiv Patnaik
 * Created on Nov 4, 2005
 * @version 1.0
 * 
 * Copyright  2005 VHA. All rights reserved
 */
public interface CountyDAO extends LookupsDAO
{
    /**
     * Get County by County name and State Postal Code 
     * e.g County = "Montgomery", State Postal Code = "OH"
     * 
     * Returns null if there is no match.
     * @return County A corresponding County by County name and state code
     */
    public County getCountyByCountyNameAndStateCode(String countyName, String stateCode) throws DAOException;
}
