package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.financials.RelaxationPercentage;
import gov.va.med.fw.model.AbstractVersionedEntity;

import java.util.HashSet;
import java.util.Set;

;

/**
 * Our history "framework" was designed around the concept of a single root
 * object like Person having a graph of child objects and grandchild objects,
 * each with their own histories. The EGT history was the first case where there
 * was no single root, but rather a set of reference information for which we
 * wanted to show history. So the EGT history implementor decided to create a
 * pseudo-root object called the EGTHistorySet which would contain all
 * historical changes for all EGT values. This is a continuation of that
 * concept, although it really deserves a redesign. I don't have time right now.
 * CPB
 * 
 * @author DNS   barryc
 * 
 */
public class RelaxationPercentageHistorySet extends AbstractVersionedEntity {

	private static final long serialVersionUID = -5759991975473155420L;

	private Set relaxationPercentages;

	public Set getRelaxationPercentages() {
		if (relaxationPercentages == null)
			relaxationPercentages = new HashSet();
		return relaxationPercentages;
	}

	public void setRelaxationPercentages(Set relaxationPercentages) {
		this.relaxationPercentages = relaxationPercentages;
	}

	public void addRelaxationPercentage(RelaxationPercentage rp) {
		getRelaxationPercentages().add(rp);
	}

}
