/********************************************************************
 * Copyright  2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.financials.RelaxationPercentage;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.persistent.DAOException;

import java.util.Iterator;
import java.util.List;

import org.hibernate.Session;

/**
 * @author DNS   barryc
 */
public class RelaxationPercentageHistoryDAOImpl extends
		FinancialsHistoryDAOImpl {
	private static final long serialVersionUID = -1487259293872228859L;

	private static final String getHistoryByChangeTimeQuery = "relaxationPercentageQuery_GetHistoryByChangeTime";

	public RelaxationPercentageHistoryDAOImpl() {
		super();
		setSingleRoot(false);
	}

	/**
	 * Retrieves historical data. This is a hack override to the standard
	 * HistoryDaoImpl to support multiple child objects without a single root, I
	 * don't have time to investigate a better solution right now. CPB
	 * 
	 * @param changeEvent
	 * @return
	 */
	protected AbstractVersionedEntity getHistoricalEntity(Session session,
			ChangeEvent changeEvent) throws DAOException {
		List objResults = null;
		Iterator objIter = null;

		RelaxationPercentageHistorySet rpSet = new RelaxationPercentageHistorySet();

		objResults = session.getNamedQuery(getHistoryByChangeTimeQuery).list();

		if (objResults != null) {
			for (objIter = objResults.iterator(); objIter.hasNext();) {
				RelaxationPercentage rp = (RelaxationPercentage) objIter.next();
				rpSet.addRelaxationPercentage(rp);

				/*
				 * evict the data, since the default evict behavior in the base
				 * class doesn't work here. The top level objects are merely
				 * empty holders
				 */
				if (rp != null) {
					evict(rp);
				}
			}
		}

		return rpSet;
	}
}