/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.history;

// Java imports
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.persistent.DAOException;

public class MilitaryServiceHistoryDAOImpl extends HistoryDAOImpl {


	/**
	 * 
	 */
	private static final long serialVersionUID = 5883803289400806934L;

	/**
	 * A default constructor
	 */
	public MilitaryServiceHistoryDAOImpl() {
		super();
	}

	protected void processData(AbstractVersionedEntity entity, int processTask) throws DAOException
	{
		super.processData(entity, processTask);

		// manually access Camp Lejeune data as framework code doesn't support
		Person p = (Person)entity;
		CampLejeuneVerification clv = p.getCampLejeuneVerification();
		if (clv != null) {
			String propName = "internalCampLejeuneVerificationMethods";
			try {
				processNestedProperty(clv, propName, processTask);
			} catch (Exception e) {
				throw new DAOException("Unable to " + (processTask==ACCESS_ONLY?"access ":"process deleted records from ")
						+ "property:" + propName, e);
			}
		}
	}
}