/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.persistent.history;

// Java classes
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

// Common classes

/** A generic interface to provide standard operations for retrieving history for an object
 * 
 * @author DNS   CHENJ2
 */
public interface HistoryDAO extends Serializable {
	
	public Set getHistoryChangeTimes(EntityKey entityKey) throws DAOException;
	public HistoricalInfo getHistoryByChangeTime(ChangeEvent changeEvent) throws DAOException;
    public List getDeletedEntities(Class clazz) throws DAOException;
}