/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.history;

// Java Classes
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.lang.Validate;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;

// Common Classes

/**
 * @author VHADMAHAGADORNB
 *
 */
public class HandBookHistoryDAOImpl extends HistoryDAOImpl implements
		HandBookHistoryDAO {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2819460436660619999L;
	
    private static final String FIND_ALL_BY_ID = "HandBookMailQueueHistory_getAllById";
    private static final String FIND_ALL_COMMENTS_BY_ID = "HandBookMailQueueHistory_getAllCommentsById";
    private static final String FIND_ALL_STATUS_BY_ID = "HandBookMailStatusHistory_getAllById";

	/**
	 * A default constructor
	 */
	public HandBookHistoryDAOImpl() {
		super();
	}

	public List getHandBookMailQueueHistory(BigDecimal handBookMailQueueId) throws DAOException {
        BigDecimal[] paramValues = new BigDecimal[]{handBookMailQueueId};
    	String[] paramFields = {"identifier"}; 
       try
        {
           return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_ALL_BY_ID, paramFields, paramValues);
        }
        catch (Exception ex)
        {
            throw new DAOException("Failed to find HISTORY Handbook Mail Queue Entries based on Id: " + handBookMailQueueId, ex);
        }
	}

	public List getHandBookMailQueueCommentHistory(BigDecimal handBookMailQueueId) throws DAOException {
        BigDecimal[] paramValues = new BigDecimal[]{handBookMailQueueId};
    	String[] paramFields = {"identifier"}; 
       try
        {
           return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_ALL_COMMENTS_BY_ID, paramFields, paramValues);
        }
        catch (Exception ex)
        {
            throw new DAOException("Failed to find HISTORY Handbook Mail Queue Comment Entries based on Id: " + handBookMailQueueId, ex);
        }
	}

	public List getHandBookMailStatusHistory(BigDecimal handBookMailQueueId) throws DAOException {
        BigDecimal[] paramValues = new BigDecimal[]{handBookMailQueueId};
    	String[] paramFields = {"handbookMailQueueId"}; 
       try
        {
           return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_ALL_STATUS_BY_ID, paramFields, paramValues);
        }
        catch (Exception ex)
        {
            throw new DAOException("Failed to find HISTORY Handbook Mail Status Entries based on Id: " + handBookMailQueueId, ex);
        }
	}

}