/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.persistent.history;


// Java classes
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.service.impl.FinancialsChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;

import java.util.Set;
import java.util.List;
import java.io.Serializable;

// Common classes

/** A generic interface to provide standard operations for retrieving history for an object
 * 
 * @author DNS   CHENJ2
 */
public interface FinancialsHistoryDAO extends HistoryDAO {
	
	public Set getHistoryChangeTimes(EntityKey entityKey, Integer incomeYear) throws DAOException;
	public HistoricalInfo getHistoryByChangeTime(FinancialsChangeEvent changeEvent) throws DAOException;
	public IncomeTest findConversionBaseTest(IncomeTest incomeTest) throws DAOException;
	public List getIncomeTestStatusesForIVMReversal(Serializable key) throws DAOException;		
}