/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.history;

// Java imports
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractVersionedEntity;

import org.apache.commons.lang.Validate;

/**
 * @author Muddaiah Ranga
 * @author DNS   CHENJ2
 * @version 1.0
 */
public class EnrollmentHistoryDAOImpl extends AbstractSingleAssocHistoryDAOImpl {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3296615714430257180L;

	
	/**
	 * A default constructor
	 */
	public EnrollmentHistoryDAOImpl() {
		super();
	}

	/**
	 * Given the root of the tree, return the object at the many end of the relationship
	 * By default, this is the same as the root.
	 * @param rootEntity
	 * @return
	 */
	protected AbstractVersionedEntity getManyEndParent(AbstractVersionedEntity rootEntity)
	{
		return ((Person)rootEntity).getEnrollmentDetermination();
	}

	/*
	 * 
	 * @see gov.va.med.esr.common.persistent.history.AbstractSingleAssocHistoryDAOImpl#getChild(gov.va.med.fw.model.AbstractVersionedEntity)
	 */
	protected AbstractVersionedEntity getSingleEndChild(AbstractVersionedEntity p) {
		
		Validate.isTrue(p instanceof EnrollmentDetermination);
		return ((EnrollmentDetermination)p).getEgtSetting();
	}

	/*
	 * 
	 * @see gov.va.med.esr.common.persistent.history.AbstractSingleAssocHistoryDAOImpl#setSingleEndChild(gov.va.med.fw.model.AbstractVersionedEntity, gov.va.med.fw.model.AbstractVersionedEntity)
	 */
	protected void setSingleEndChild(AbstractVersionedEntity p, AbstractVersionedEntity c) {	 
	 
		Validate.isTrue(p instanceof EnrollmentDetermination);
		Validate.isTrue(c instanceof EGTSetting);

		((EnrollmentDetermination) p).setEgtSetting((EGTSetting)c);
	}

}