/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.history;

// Java Classes
import java.util.Iterator;
import java.util.List;

// Library Classes
import org.hibernate.Session;

// Framework Classes
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.persistent.DAOException;
// Common Classes
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.common.model.ee.EGTSetting;

/**
 * @author DNS   CHENJ2
 * Returns egt history data.
 */
public class EGTHistoryDAOImpl extends FinancialsHistoryDAOImpl {
    
	/**
	 * 
	 */
	private static final long serialVersionUID = -1487259293872228859L;
	
	// getHistoryByChangeTime queries name
	private static final String getHistoryByChangeTimeQuery = "egtSettingQuery_GetHistoryByChangeTime";
	
	/**
	 * A default constructor
	 */
	public EGTHistoryDAOImpl() {
		super();
		this.setSingleRoot(false);
	}

	/**
	 * Retrieves historical data.  Customized using hand coded HQL.  This is 
	 * due to spouseFinancials.spouse is a many-to-one relationship, and therefore
	 * is not allowed the "order-by" clause, or the filters defined in the mapping
	 * file.
	 * @param changeEvent
	 * @return
	 */
	protected AbstractVersionedEntity getHistoricalEntity(Session session, ChangeEvent changeEvent)
		throws DAOException
	{
		List objResults = null;
		Iterator objIter = null;
		EGTSetting egt = null;
		
		// create empty holder object: EGTHistorySet
		EGTHistorySet egtSet = new EGTHistorySet();
		
		objResults = session.getNamedQuery(getHistoryByChangeTimeQuery).list();
		
		if (objResults != null) {
			for (objIter = objResults.iterator(); objIter.hasNext();) {
				egt = (EGTSetting) objIter.next();
				egtSet.addEGTSetting(egt);

				// evict the data, since the default evict behavior in the base
				// class doesn't work here.  The top level objects are merely empty holders
				if (egt != null) {
					evict(egt);
				}
			}
		}
		
		return egtSet;	
	}
}