/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.history;

// Java Classes
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.lang.Validate;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;

// Common Classes

/**
 * @author DNS   faulkj
 *
 */
public class CorrespondenceHistoryDAOImpl extends HistoryDAOImpl implements
		CorrespondenceHistoryDAO {

	/**
	 *
	 */
	private static final long serialVersionUID = -2819460436660619999L;

	public static final String FIND_CORR_HISTORY = "correspondenceHistory_findCorrespondenceHistory";

	/**
	 * A default constructor
	 */
	public CorrespondenceHistoryDAOImpl() {
		super();
	}

	public List getCorrespondenceHistory(BigDecimal correspondenceId) throws DAOException {
		BigDecimal[] paramValues = new BigDecimal[]{correspondenceId};
    	String[] paramFields = {"correspondenceId"};
       try
        {
           return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_CORR_HISTORY, paramFields, paramValues);
        }
        catch (Exception ex)
        {
            throw new DAOException("Failed to find HISTORY correspondence Entries based on Id: " + correspondenceId, ex);
        }
	}



}