/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.hibernate;

// Java Classes
import java.io.Serializable;
import java.math.BigDecimal;

import javax.sql.DataSource;

// Library Classes
import org.springframework.jdbc.core.JdbcTemplate;

// Framework Classes

// Common Classes
import gov.va.med.esr.service.UniqueIdentifierGenerator;

/**
 * Generates a unique number from an Oracle sequence.
 * 
 * @author Martin Francisco
 */
public class OracleSequenceGenerator
    implements UniqueIdentifierGenerator
{
    private JdbcTemplate template = null;
    private String selectStatement = null;

    public OracleSequenceGenerator(DataSource dataSource, String sequenceName)
    {
        super();

        this.template = new JdbcTemplate(dataSource);
        this.selectStatement = "select " + sequenceName + ".nextval from dual";
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.impl.UniqueIdentifierGenerator#generate()
     */
    public Serializable generate()
    {
        return (Serializable)this.template
            .queryForObject(this.selectStatement, BigDecimal.class);
    }
}