package gov.va.med.esr.common.persistent.hbp;

import gov.va.med.esr.common.model.hbp.HealthBenefitPlanName;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.util.List;

/**
 * A DAO to add, update and find the HealthBenfitPlanName and HealthBenfitPlanDefinition.
 * 
 */
public interface HBPDefinitionDAO extends DAOOperations {
    
 
    /**
     * Find the HealthBenefitPlanName given the unique identifier.
     * 
     * @param planNameId
     * @return HealthBenefitPlanName Object.
     * @throws DAOException if there is any error finding the planName.
     * @throws IllegalArgumentException if input is null.
     */
    public HealthBenefitPlanName getHealthBenefitPlanNameById(EntityKey planNameId) throws DAOException;
       
    public List<HealthBenefitPlanName> findAllHealthBenefitPlanNames() throws DAOException;
          
}