/*******************************************************************************
 * Copyright  2010 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.persistent.financials.hibernate;

import gov.va.med.esr.common.model.financials.RelaxationPercentage;
import gov.va.med.esr.common.persistent.financials.RelaxationPercentageDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import java.util.List;

/**
 * Provides data access methods to perform CRUD operations on relaxation
 * percentages
 * 
 * @author DNS   barryc
 */
public class RelaxationPercentageDAOImpl extends GenericDAOImpl implements
		RelaxationPercentageDAO {
	private static final long serialVersionUID = -8766370650503687355L;

	public RelaxationPercentage getRelaxationPercentageByIncomeYear(
			int incomeYear) throws DAOException {
		List results = findByNamedParam(
				"from " + RelaxationPercentage.class.getName()
						+ " where incomeYear = :incomeYear", "incomeYear",
				new Integer(incomeYear));
		return (RelaxationPercentage) (results.isEmpty() ? null : results
				.get(0));
	}

	public List findAll() {
		return getHibernateTemplate().find(
				"from " + RelaxationPercentage.class.getName() + " order by incomeYear");
	}

}