/*******************************************************************************
 * Copyright  2010 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.persistent.financials;

import gov.va.med.esr.common.model.financials.RelaxationPercentage;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.io.Serializable;
import java.util.List;

/**
 * Provides data access methods to perform CRUD operations on relaxation
 * percentages
 * 
 * @author DNS   barryc
 */
public interface RelaxationPercentageDAO extends Serializable, DAOOperations {

    RelaxationPercentage getRelaxationPercentageByIncomeYear(
            int incomeYear) throws DAOException;

	List findAll();
    
}
