/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.ee.hibernate;

// Java classes
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import org.hibernate.Query;

// Library classes

// Framework classes
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.esr.common.persistent.ee.VoaFileAttachmentDAO;

// Common classes

/**
 * @author Martin Francisco
 */
public class VoaFileAttachmentDAOImpl
    extends GenericDAOImpl
    implements VoaFileAttachmentDAO
{
	

	private static final long serialVersionUID = 757631389841938318L;

	/* named queries */
	private static final String FIND_ATTACHMENT_BY_PERSON_ID = "findAttachmentByPersonId";
	private static final String FIND_ATTACHMENT_BY_APPLICATION_ID = "findAttachmentByApplicationId";
	private static final String UPDATE_ATTACHMENT_WITH_PERSON_ID = "updateAttachmentWithPersonId";

	/* param names */
	private static final String PARAM_PERSONID = "personId";
	private static final String PARAM_MESCONTROLLID = "msgControlId";
	/**
     * Gets the VOA attachment by person ID
     * 
     * @param personId
     * @return The list of VOA attachments, null when empty
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    public List findVoaAttachmentByPersonId(BigDecimal personId) throws DAOException
    {
        List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(
            	FIND_ATTACHMENT_BY_PERSON_ID, "personId", personId);

            return ((results == null) || results.isEmpty()) ? null
                : results;
    }
  
	/**
     * Gets the VOA attachment by VOA application ID
     * 
     * @param applicationId
     * @return The list of VOA attachments, null when empty
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    public List findVoaAttachmentByApplicationId(BigDecimal applicationId) throws DAOException
    {
        List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(
            	FIND_ATTACHMENT_BY_APPLICATION_ID, "applicationId", applicationId);

            return ((results == null) || results.isEmpty()) ? null
                : results;
    }

	/**
     * Update the VOA attachment attributes
     * 
     * @param attachment
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    public void updateAttachmentAttributes(VoaFileAttachment attachment)  throws DAOException
    {
    	super.saveObject(attachment);
    }

	/**
     * Update the VOA attachment with person id for a particular message control id
     * 
     * @param msgControlId, personId
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */   
    public void updateVoaAttachmentWithPersonId(String msgControlId, BigDecimal personId)  throws DAOException
    {
		//Original
    	//Query query = super.getSession().getNamedQuery(UPDATE_ATTACHMENT_WITH_PERSON_ID);
    	//New
    	Query query = this.getHibernateTemplate().getSessionFactory().getCurrentSession().getNamedQuery(UPDATE_ATTACHMENT_WITH_PERSON_ID);
		query.setParameter(PARAM_MESCONTROLLID, msgControlId);
		query.setParameter(PARAM_PERSONID, personId);
		int updateCount = query.executeUpdate();                				

		if (updateCount < 1) {
			if(logger.isWarnEnabled())
				logger.warn("VoaFileAttachment not updated with persoin: " + personId + " for msgControlId=" + msgControlId);
		}
    }
 }