/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.ee.hibernate;

// Java Classes
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

// Library Classes
import org.springframework.dao.DataAccessException;
import org.apache.commons.lang.Validate;

// Framework Classes
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

// Common Classes
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.persistent.ee.EGTSettingDAO;

/**
 * @author Martin Francisco
 */
public class EGTSettingDAOImpl
    extends GenericDAOImpl
    implements EGTSettingDAO
{
    private static final long serialVersionUID = 757631389841938318L;

    /**
     *  
     */
    public EGTSettingDAOImpl()
    {
        super();
    }

    /*
     * @see gov.va.med.esr.common.persistent.ee.EGTSettingDAO#getActive(java.util.Date)
     */
    public EGTSetting getActive() throws DAOException
    {
        List results = null;

        try
        {
            results = super.getHibernateTemplate().findByNamedQuery(
            	"egtSettingQuery_FindActive");

            return ((results == null) || results.isEmpty()) ? null
                : (EGTSetting)results.get(0);
        }
        catch(DataAccessException e)
        {
            throw new DAOException("Failed to get current active EGTSetting", e);
        }
    }

    public EGTSetting getActive(Date asOf) throws DAOException
    {
        try
        {
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(
            	"egtSettingQuery_FindActiveAsOf", "asOfDate", asOf);

            return ((results == null) || results.isEmpty()) ? null
                : (EGTSetting)results.get(0);
        }
        catch(DataAccessException e)
        {
            throw new DAOException("Failed to get current active EGTSetting", e);
        }
    }
    
    /**
     * 
     */
    public Set getFutureEGTSettings() throws DAOException
    {
        Set futureEGTs = new HashSet();
    	List results = null;
        
        try
        {
            results = super.getHibernateTemplate().findByNamedQuery(
            	"egtSettingQuery_FindFuture");

            
            if (results != null) {
				for (Iterator iter = results.iterator(); iter.hasNext();) {
					futureEGTs.add((EGTSetting) iter.next());
				}
			}			
        }
        catch(DataAccessException e)
        {
            throw new DAOException("Failed to get future EGTSettings", e);
        }
    
        return futureEGTs;
    }
 }