/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.ee;

// Java classes
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

// Library classes

// Framework classes
import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

// Common classes

/**
 * @author George Tsai
 */
public interface VoaFileAttachmentDAO
    extends Serializable
{
    /**
     * Gets the active EGT setting as of any date.
     * 
     * @return The active EGT setting as of the specified date.
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    public List findVoaAttachmentByPersonId(BigDecimal personId) throws DAOException;
    
    public List findVoaAttachmentByApplicationId(BigDecimal applicationId) throws DAOException;
    
    public void updateAttachmentAttributes(VoaFileAttachment attachment)  throws DAOException;
    
    public void updateVoaAttachmentWithPersonId(String msgControlId, BigDecimal personId)  throws DAOException;


   
 }