/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.persistent.ee;

// Java classes
import java.io.Serializable;
import java.util.Date;
import java.util.Set;

// Library classes

// Framework classes
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

// Common classes

/**
 * @author Martin Francisco
 */
public interface EGTSettingDAO
    extends DAOOperations
{
    /**
     * Gets the active EGT setting as of any date.
     * 
     * @return The active EGT setting as of the specified date.
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    public EGTSetting getActive() throws DAOException;
    
    public EGTSetting getActive(Date asOf) throws DAOException;

    public Set getFutureEGTSettings() throws DAOException;
   
 }