package gov.va.med.esr.common.persistent.demographic.hibernate;


import java.math.BigDecimal;
import java.util.List;

import org.springframework.dao.DataAccessException;

import gov.va.med.esr.common.model.lookup.ConfidentialAddressCategoryType;
import gov.va.med.esr.common.model.person.PersonMergeInfo;
import gov.va.med.esr.common.persistent.demographic.ConfidentialAddressCategoryTypeDAO;
import gov.va.med.esr.common.persistent.lookup.hibernate.LookupsDAOImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

/**
 * @author Rasheed Rabbi
 * 
 */

public class ConfidentialAddressCategoryTypeDAOImpl extends LookupsDAOImpl
		implements ConfidentialAddressCategoryTypeDAO {

	private static final long serialVersionUID = 2019310671598396681L;
	private static final String Get_All_ConfAddrCategory_SQL = "getAllConfAddrCategoryType";
	private static final String Get_ConfAddrCategory_By_Code = "getConfAddrCategoryTypeByCode";
	private static final String CODE_ID_PARAM = "code";

	   
    public static String getGetAllConfaddrcategorySql() {
		return Get_All_ConfAddrCategory_SQL;
	}

    /**
     * This method will retrieve all the category types from STD_CONFIDENTIALADDRESSCAT
     * table.
     * @return ConfidentialAddressCategoryType
     * @throws ServiceException
     */
	public List getAllConfidentialAddressCategoryTypes() throws DAOException{
	   	List conAddList = null;
	   	conAddList = this.getHibernateTemplate().findByNamedQuery(Get_All_ConfAddrCategory_SQL);	   	  
	   	return conAddList;
    }
	
	/**
	 * This method will will retrieve a specific row from STD_CONFIDENTIALADDRESSCAT
	 * by the code number.
	 * @param code
     * @return ConfidentialAddressCategoryType
     * @throws ServiceException
     */
	public ConfidentialAddressCategoryType getConfidentialAddressCategoryTypeByCode(String code) throws DAOException{
		
		try {
			List results = this.getHibernateTemplate().findByNamedQueryAndNamedParam(Get_ConfAddrCategory_By_Code, CODE_ID_PARAM, code);
			return ((results == null) || results.isEmpty()) ? null
					: (ConfidentialAddressCategoryType) results.get(0);
		} catch (DataAccessException ex) {
			throw new DAOException(
					"Failed to find ConfidentialAddressCategoryType by codeId.", ex);
		}
  }


}
