/*
 * Created on Feb 23, 2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.persistent.demographic.hibernate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.hibernate.Query;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;

import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.persistent.demographic.AddressDAO;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;

/**
 * @author DNS   TSAIG
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AddressDAOImpl extends AbstractDAOImpl implements AddressDAO{

    /**
	 *
	 */
	private static final long serialVersionUID = -9196318501892030277L;
	private static final String PERSON_ADDRESS_NAMED_SQL = "getAddressByPersonId";
	private static final String ADDRESS_BY_ID = "addressByAddressId";
    private static final String PERSON_ID_PARAM = "personId";
    private static final String PERSON_ADDRESS_NAMED_QUERY = "addressesByPersonId";
/*        "SELECT a.line1 ,a.line2 ,a.line3 ,a.city ,a.state ,a.province ,a.postalCode ,a.zipCode ,"+
		" a.zipPlus4 ,a.county ,a.country"+
		" from Address a where a.person.identifier = ";*/

/*        "SELECT a.changeDate , a.changeSource, a.changeSite ,a.changeDate ,a.startDate ,a.endDate ,a.phoneNumber ,a.badAddressReason ,"+
		" a.dateCheckedByNCOA ,a.ncoaInvalidUndeliverableDate ,a.ncoaStatus ,a.ncoaZipPlus4MatchCode ,a.zipPlus4NoMatchReason ,"+
		" a.type ,a.line1 ,a.line2 ,a.line3 ,a.city ,a.state ,a.province ,a.postalCode ,a.zipCode ,"+
		" a.zipPlus4 ,a.county ,a.country"+
		" from Address a where a.person.identifier = ";*/



    public List getPersonAddresses(BigDecimal personId) throws DAOException
    {
        List lst = null;
        if (personId == null)
            return lst;

        try {

/*			//<sql-query name="getAddressByPersonId">.. not working, null pointer exception
            Query query = super.getSession().getNamedQuery(PERSON_ADDRESS_NAMED_QUERY);
//            Query query = super.getSession().getNamedQuery(PERSON_ADDRESS_SQL);
            query.setBigDecimal(PERSON_ID_PARAM, personId);
            lst = query.list();*/

            lst = this.getHibernateTemplate().findByNamedQueryAndNamedParam(PERSON_ADDRESS_NAMED_QUERY, PERSON_ID_PARAM, personId);
        }
        catch( Exception e ) {
            throw new DAOException( "Failed to find Address list by person id", e);
        }

        return mapToAddressList(lst);
    }

    public Address getAddressById(BigDecimal addressId) throws DAOException {
    	Address address = null;
    	try {
    	   	List lst = this.getHibernateTemplate().findByNamedQueryAndNamedParam(ADDRESS_BY_ID, "addressId", addressId);
    	   	List addrList = mapToAddressList(lst);
    	   	if (addrList.size() > 0) {
    	   		address = (Address)addrList.get(0);
    	   	}
    	} catch( Exception e ) {
            throw new DAOException( "Failed to find Address by id", e);
        }

     	return address;
    }

    private List mapToAddressList(List lst)
    {
        if (lst == null)
            return null;

        List addrList = new java.util.ArrayList();

        Address addr = null;

        for (int i=0; i< lst.size(); i++)
        {
            Object [] attributes = (Object []) lst.get(i);

            addr = new Address();

            if (attributes[0] != null)
                addr.setStartDate((ImpreciseDate)attributes[0]);
            if (attributes[1] != null)
                addr.setEndDate((ImpreciseDate)attributes[1]);
            if (attributes[2] != null)
                addr.setBadAddressReason((BadAddressReason)attributes[2]);
            if (attributes[3] != null)
                addr.setType((AddressType)attributes[3]);
            if (attributes[4] != null)
                addr.setLine1((String)attributes[4]);
            if (attributes[5] != null)
                addr.setLine2((String)attributes[5]);
            if (attributes[6] != null)
                addr.setLine3((String)attributes[6]);
            if (attributes[7] != null)
                addr.setCity((String)attributes[7]);
            if (attributes[8] != null)
                addr.setState((String)attributes[8]);
            if (attributes[9] != null)
                addr.setProvince((String)attributes[9]);
            if (attributes[10] != null)
                addr.setPostalCode((String)attributes[10]);
            if (attributes[11] != null)
                addr.setZipCode((String)attributes[11]);
            if (attributes[12] != null)
                addr.setZipPlus4((String)attributes[12]);
            if (attributes[13] != null)
                addr.setCounty((String)attributes[13]);
            if (attributes[14] != null)
                addr.setCountry((String)attributes[14]);
            if (attributes[15] != null)
                addr.setNcoaInvalidUndeliverableDate((Date)attributes[15]);

            if (logger.isDebugEnabled())
                logger.debug("AddressDAO map to addressList attributes: " + attributes + " address: " + addr);

            addrList.add(addr);
        }


        return addrList;

    }
}
