/**
 * 
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.VCDeterminationHistoryForm;
import gov.va.med.esr.common.persistent.comms.WaittimeDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.SQLQuery;


/**
 * DAO implementation for Delivery Preference
 * 
 * @author DNS   CHINNR
 */
public class WaittimeDAOImpl extends GenericDAOImpl implements
		WaittimeDAO {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7523096165171457713L;

	/*
	 * Default constructor
	 */
	public WaittimeDAOImpl() {
		super();
	}

	/**
	 * Find Waittime by personId. If not found, return NULL.
	 */
//	@SuppressWarnings({ "rawtypes" })
	@Override
	public List findWaittimeByPersonId(BigDecimal personId)
			throws DAOException {
		List result = null;

		String FIND_BY_WT_PERSON_ID = "waittimeQuery_FindByPersonId";
		String[] personIdParamFields = { "personId" };
		BigDecimal[] personIdParamValues = new BigDecimal[] { personId };

		try {
			result = super.getHibernateTemplate()
					.findByNamedQueryAndNamedParam(FIND_BY_WT_PERSON_ID,
							personIdParamFields, personIdParamValues);
		} catch (Exception ex) {
			throw new DAOException(
					"Failed to find waittime based on person Id: "
							+ personId, ex);
		}
		return result;
	}
	
	public List findVCChangeTimeLog(BigDecimal personId)
			throws DAOException {
		List result = null;

		String FIND_BY_VCT_PERSON_ID = "vc_change_time";
		String[] personIdParamFields = { "personId" };
		BigDecimal[] personIdParamValues = new BigDecimal[] { personId };

		try {
			
			String query = "SELECT  RECORD_CREATED_DATE AS VC_HIS_TIME  FROM VCELIGIBILITY_H WHERE PERSON_ID = :personId";
			
			SQLQuery sqlQuery = super.getSession().createSQLQuery(query);
		
			sqlQuery.setParameter("personId", personId);
			System.out.println("xxxxxxxx jj xx");

			//result = sqlQuery.list();
			
			if(result == null){
				result = new ArrayList();
				result.add("12-12-1212 00000");
				result.add("12-12-1212 00000");
			}
			
		} catch (Exception ex) {
			throw new DAOException(
					"Failed to find findVCChangeTimeLog based on person Id: "
							+ personId, ex);
		}
		return result;
	}

	@Override
	public VCDeterminationHistoryForm findVCDeterminationHistory(String input)
			throws DAOException {
		VCDeterminationHistoryForm hist = new VCDeterminationHistoryForm();
		return hist;
	}

}
