/**
 * 
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.persistent.comms.GeocodeTransmitDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import java.math.BigDecimal;
import java.util.List;


/**
 * DAO implementation for Delivery Preference
 * 
 * @author DNS   CHINNR
 */
public class GeocodeTransmitDAOImpl extends GenericDAOImpl implements
		GeocodeTransmitDAO {


	/**
	 * 
	 */
	private static final long serialVersionUID = 8301636089964321630L;

	/*
	 * Default constructor
	 */
	public GeocodeTransmitDAOImpl() {
		super();
	}

	/**
	 * Find Geocode Transmit by personId. If not found, return empty list.
	 */
//	@SuppressWarnings({ "rawtypes" })
	@Override
	public List findGeocodeTransmitByPersonId(BigDecimal personId)
			throws DAOException {
		List result = null;

		String FIND_BY_GT_PERSON_ID = "geocodeTransmitQuery_FindByPersonId";
		String[] personIdParamFields = { "personId" };
		BigDecimal[] personIdParamValues = new BigDecimal[] { personId };

		try {
			result = super.getHibernateTemplate()
					.findByNamedQueryAndNamedParam(FIND_BY_GT_PERSON_ID,
							personIdParamFields, personIdParamValues);
		} catch (Exception ex) {
			throw new DAOException(
					"Failed to find geocode transmit based on person Id: "
							+ personId, ex);
		}
		return result;
	}

}
