package gov.va.med.esr.common.persistent.comms.hibernate;


import gov.va.med.esr.common.model.comms.FileInfo;
import gov.va.med.esr.common.persistent.comms.FileInfoDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class FileInfoDAOImpl extends AbstractDAOImpl implements FileInfoDAO {

	public static final String PARAM_IDENTIFIER = "identifier";
    public static final String FIND_BY_IDENTIFIER = "FileInfo_Identifier";

	public FileInfo getFileInfoById(BigDecimal fileId) throws DAOException
	{
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_IDENTIFIER,PARAM_IDENTIFIER, fileId );

            if (logger.isDebugEnabled())
                logger.debug("FileInfoDAO.getFileInfobyId results: " + results);

            // Should only return one value
            return results.isEmpty() ? null : (FileInfo) results.get(0);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the file info by identifier", e);
        }
	}
}
