/*
 * Created on Sep 17, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

package gov.va.med.esr.common.persistent.comms.hibernate;

/**
 * @author DNS   TSAIG
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

//Java classes
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;

//Library classes


//Framework classes
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import gov.va.med.fw.persistent.DAOException;

//EDB classes

/**
* A DAO class to provide specific business information about a ExportSnapshot
* 
* @author Vu Le
* @verion 1.0
*/

import gov.va.med.esr.common.model.comms.ExportSnapshot;
import gov.va.med.esr.common.persistent.comms.ExportSnapshotDAO;

public class ExportSnapshotDAOImpl extends AbstractDAOImpl implements ExportSnapshotDAO
{	

	private static final long serialVersionUID = -4654659271545539092L;

    public ExportSnapshot getCurrentSnapshot() throws DAOException
	{
	    List lstP = null;
	    List lstC = null;
	    List lstL = null;


	    try {
	        lstP = getHibernateTemplate().find( "select max(p.identifier) from AacLetterRequest p");
//    		lstC = getHibernateTemplate().find( "select max(c.identifier) from AacLetterCanceledRequest c");
	        lstL = getHibernateTemplate().find( "select max(l.identifier) from CommsLogEntry l");
/*    		org.springframework.orm.hibernate.HibernateTemplate t = getHibernateTemplate();
     		lstP = t.find( "select max(p.commsPrintRequestIdentifier) from PrintRequest p");
     		lstC = t.find( "select max(c.commsPrCancelIdentifier) from CancelledPrintRequest c");
     		lstL = t.find( "select max(l.identifier) from CommsLogEntry l");
 */
	    }
 	    catch( Exception e ) {
 	        throw new DAOException( "Failed to find current snapshot", e);
 	    } 
 	    
	    ExportSnapshot ess = new ExportSnapshot();
	    ess.setPrintRequestId(getDecimalFromList(lstP));
//	    ess.setCancelledPrintRequestId(getDecimalFromList(lstC));
	    ess.setCommsLogId(getDecimalFromList(lstL));

 	    return ess; 
	}
	
	private BigDecimal getDecimalFromList(List lst)
	{
		if (lst == null || lst.size() ==0)
			return null;
		
		return (BigDecimal)lst.get(0);
	}


	public ExportSnapshot getPreviousSnapshot() throws DAOException
	{

	    List lst = null;

 	    try {
 	        lst = getHibernateTemplate().find( "from ExportSnapshot e order by e.identifier desc");
 	    }
 	    catch( Exception e ) {
 	        throw new DAOException( "Failed to find previous snapshot", e);
 	    }
 	    
 	    if (lst == null || lst.size() == 0)
 	    	return null;
 	    
 	    return (ExportSnapshot)lst.get(0);
		
	}
	
	
	public ExportSnapshot getFirstSnapshotOnDate(Date onDate) throws DAOException {
		List lst = null;
		int max = getHibernateTemplate().getMaxResults();
		try {
			//only wants the last record just before the requested date
			getHibernateTemplate().setMaxResults(1);
			lst = getHibernateTemplate().findByNamedParam("select p.identifier from AacLetterRequest p where p.createdOn < :onDate order by p.identifier desc",
														  "onDate", onDate);
		}
		catch(Exception e)
		{
			//reset to whatever it was before the query
			getHibernateTemplate().setMaxResults(max);
			throw new DAOException("Failed to find first snapshot on " + onDate.toString(), e);
		}
		
		//reset to whatever it was before the query
		getHibernateTemplate().setMaxResults(max);
		
		if(lst == null || lst.size() == 0)
			return null;
		ExportSnapshot ess = new ExportSnapshot();
	    ess.setPrintRequestId(getDecimalFromList(lst));
	    
		return ess;
	}

	public void insert(ExportSnapshot newEntry) throws DAOException
	{
	    super.saveObject(newEntry);
	}

}

