/*
 * Created on May 10, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.Directory;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.esr.common.persistent.comms.DocumentReceiptDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;


/**
 * @author DNS   TSAIG
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 * public class DocumentReceiptDAOImpl extends AbstractDAOImpl implements
		DocumentReceiptDAO
 */
public class DocumentReceiptDAOImpl extends AbstractDAOImpl implements DocumentReceiptDAO  {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6392209931355445693L;
	private static final String FIND_LATEST_BY_PERSON = "DocumentReceipt_All_ByReceiptDate_Desc";
	private DAOOperations dao = null;

	public DAOOperations getDao() {
		return dao;
	}

	public void  setDao(DAOOperations dao) {
		this.dao = dao;
	}
	
	public DocumentReceipt findDocumentReceiptById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_IDENTIFIER,PARAM_IDENTIFIER,identifier );

            // Should only return one value
            return results.isEmpty() ? null : (DocumentReceipt) results.get(0);
        } 
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry by identifier", e);
        }
    }
	
	/**
	 * @see gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO#getByControlId(java.lang.String)
	 */
	public DocumentReceipt findDocumentReceiptByVersion(String vpid, String versionNumber) throws DAOException {
		try {
			String[] paramNames = { PARAM_PERSON_VPID,PARAM_VERSION_NUMBER };
            Object[] params = { vpid, versionNumber };
			HibernateTemplate tpl = this.getHibernateTemplate();
			List results = tpl.findByNamedQueryAndNamedParam(FIND_BY_VERSION, paramNames, params);			

			// Should only return one value
			return results.isEmpty() ? null : (DocumentReceipt) results.get(0);
		} 
		catch (DataAccessException e) {
			throw new DAOException("Failed to get the message log entry", e);
		}
	}
	
	/**
	 * @see gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO#getByControlId(java.lang.String)
	 */
	public List findDocumentReceipts(String vpid) throws DAOException {
		try {
			HibernateTemplate tpl = this.getHibernateTemplate();
			List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_PERSON,PARAM_PERSON_VPID,	vpid );

			// Should only return one value
			return results;
		} 
		catch (DataAccessException e) {
			throw new DAOException("Failed to get the message log entry", e);
		}
	}

	/**
	 * find the list of document receipts sorted in receipt date descending order 
	 * @param vpid
	 * @return
	 * @throws DAOException
	 */
	public List findLatestDocumentReceipts(String vpid) throws DAOException {
		try {
			HibernateTemplate tpl = this.getHibernateTemplate();
			List results = tpl.findByNamedQueryAndNamedParam( FIND_LATEST_BY_PERSON,PARAM_PERSON_VPID,	vpid );

			// Should only return one value
			return results;
		} 
		catch (DataAccessException e) {
			throw new DAOException("Failed to get the message log entry", e);
		}
	}
	
	public DocumentReceipt findDocumentReceiptByReceiptString(String receiptString) throws DAOException{
		try {
			HibernateTemplate tpl = this.getHibernateTemplate();
			List results = tpl.findByNamedQueryAndNamedParam( FIND_BY_RECEIPT_STRING,PARAM_RECEIPT_STRING,	receiptString );

			if ( results != null  && results.size() > 0 ) {
				return (DocumentReceipt)results.get(0);
			}
			// Should only return one value
			return null;
		} 
		catch (DataAccessException e) {
			throw new DAOException("Failed to get the message log entry", e);
		}
	}


	public Directory getActiveVBRDirectoty() throws DAOException {
		HibernateTemplate tpl = this.getHibernateTemplate();
		List results = tpl.findByNamedQueryAndNamedParam( FIND_ACTIVE_VBR_DIR,"inUseFlag", "Y" );

		if ( results != null  && results.size() > 0 ) {
			return (Directory)results.get(0);
		}
		// Should only return one value
		return null;
		
	}
	
	
	public void deleteDocumentReceipt(DocumentReceipt documentReceipt) throws DAOException {
		super.removeObject(documentReceipt.getEntityKey());
	}
}
