/**
 * 
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.persistent.comms.DeliveryPreferenceDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import java.math.BigDecimal;
import java.util.List;

/**
 * DAO implementation for Delivery Preference
 * 
 * @author DNS   CHINNR
 */
public class DeliveryPreferenceDAOImpl extends GenericDAOImpl implements
		DeliveryPreferenceDAO {

	/**
	 * Auto generated serialization number.
	 */
	private static final long serialVersionUID = -2770418242092163565L;

	// HSQL reference to retrieve Delivery Preference by personId
	private static final String FIND_BY_DP_PERSON_ID = "deliveryPreferenceQuery_FindByPersonId";

	// HSQL parameters
	private static final String[] personIdParamFields = { "personId" };

	/*
	 * Default constructor
	 */
	public DeliveryPreferenceDAOImpl() {
		super();
	}

	/**
	 * Find delivery preference by personId. If not found, return NULL.
	 */
	@SuppressWarnings({ "rawtypes" })
	public DeliveryPreference findDeliveryPreferenceByPersonId(String personId)
			throws DAOException {
		DeliveryPreference result = null;

		BigDecimal[] personIdParamValues = new BigDecimal[] { new BigDecimal(
				personId) };

		try {
			List resultSet = super.getHibernateTemplate()
					.findByNamedQueryAndNamedParam(FIND_BY_DP_PERSON_ID,
							personIdParamFields, personIdParamValues);
			if (!resultSet.isEmpty()) {
				// Person has one delivery preference.
				result = (DeliveryPreference) resultSet.iterator().next();
			}
		} catch (Exception ex) {
			throw new DAOException(
					"Failed to find delivery preference based on person Id: "
							+ personId, ex);
		}

		return result;
	}
	
}
