package gov.va.med.esr.common.persistent.comms.hibernate;

// Java Classes
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType.Code;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.persistent.comms.CorrespondenceDAO;

/**
 * The DAO for Correspondence.
 *
 * @author DNS   faulkj
 */
public class CorrespondenceDAOImpl extends GenericDAOImpl implements CorrespondenceDAO
{

    private static final long serialVersionUID = 7401171707221279133L;

    public CorrespondenceDAOImpl()
    {
        super();
    }


    public List<Correspondence> findCorrespondenceByPersonId(String personId) throws DAOException {

        return null;
    }


    public Address getHistoricalAddress(BigDecimal addressHId) throws DAOException {
		// execute the named query
		Map contextData = new HashMap();
		contextData.put("addressHId", addressHId);
		HibernateCallback callback = new AbstractDAOAction(contextData) {
			public Object execute(Session session) {
				Query q = session.getNamedQuery("correspondenceQuery_findHistoryAddressById");
				q.setParameter("addressHId", (BigDecimal) getContextData().get("addressHId"));
				return q.list();
			}
		};
		List results = this.getHibernateTemplate().executeFind(callback);
		Iterator iter = results.iterator();
		Address address = null;

		//Fetch the data of results are returned
        if (iter.hasNext()) {
            Object row = iter.next();
            if (row != null) {
                address = (Address) row;
            }
        }
		//return the enrollment effective date
		return address;
	}

    public Correspondence findById(BigDecimal correspondenceId) throws DAOException {
    	try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = {PARAM_CORR_ID};
            Object[] values = {correspondenceId};

            ArrayList<Correspondence> results = new ArrayList<Correspondence>( tpl.findByNamedQueryAndNamedParam(FIND_BY_ID,
                    params, values));

            if (results != null && results.size() == 1) {
            	return results.get(0);
            }

            return null;

        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the correspondence list by form and status ", e);
        }
    }

    public ArrayList<Correspondence> findPendingCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException {
    	try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = {PARAM_PERSON_ID, PARAM_FORM_ID};
            Object[] values = {personId, formId};


            ArrayList<Correspondence> results = new ArrayList<Correspondence>( tpl.findByNamedQueryAndNamedParam(FIND_BY_FORM_AND_STATUS,
                    params, values));

            if (results != null && results.size() > 0) {
            	return results;
            }

            return null;

        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the correspondence list by form and status ", e);
        }
    }

    public ArrayList<Correspondence> findSentCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException {
    	try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = {PARAM_PERSON_ID, PARAM_FORM_ID};
            Object[] values = {personId, formId};


            ArrayList<Correspondence> results = new ArrayList<Correspondence>( tpl.findByNamedQueryAndNamedParam(FIND_SENT_BY_FORM_AND_STATUS,
                    params, values));

            if (results != null && results.size() > 0) {
            	return results;
            }

            return null;

        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the correspondence list by form and status ", e);
        }
    }

    public ArrayList<Correspondence> findAllCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException {
    	try {
            HibernateTemplate tpl = this.getHibernateTemplate();

            String[] params = {PARAM_PERSON_ID, PARAM_FORM_ID};
            Object[] values = {personId, formId};

            ArrayList<Correspondence> results = new ArrayList<Correspondence>( tpl.findByNamedQueryAndNamedParam(FIND_BY_FORMS,
                    params, values));

            if (results != null && results.size() > 0) {
            	return results;
            }

            return null;

        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the correspondence list by form and status ", e);
        }
    }


    public BigDecimal findAddressHistoryIdByPersonId(BigDecimal personId) throws DAOException {
    	try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam(FIND_ADDRESS_H_ID,
                    PARAM_PERSON_ID, personId);

            if (results != null && results.size() == 1) {
            	return (BigDecimal)results.get(0);
            }

            return null;

        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the address_h id by identifier", e);
        }

    }

}
