/**
 * 
 */
package gov.va.med.esr.common.persistent.comms;

import gov.va.med.esr.common.model.comms.VCDeterminationHistoryForm;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author DNS   RAOS
 */
public interface WaittimeDAO extends DAOOperations{

	/**
	 * Find delivery preference by personId
	 * @param personId
	 * @return: DeliveryPreference instance. Null if not found.
	 * @throws DAOException
	 */
	List findWaittimeByPersonId(BigDecimal personId) throws DAOException;
	
	public List findVCChangeTimeLog(BigDecimal personId) throws DAOException;

	public VCDeterminationHistoryForm findVCDeterminationHistory(String input) throws DAOException;

}
