package gov.va.med.esr.common.persistent.comms;


import gov.va.med.esr.common.model.comms.DocumentAccessLog;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAO;
import gov.va.med.fw.persistent.DAOException;


import java.util.List;
import java.math.BigDecimal;
public interface HandBookMailQueueDAO extends DAO{
	
	/**
     * A key to look up a a named query FIND_BY_IDENTIFIER
     */
    public static final String FIND_BY_ID = "HandBookMailQueue_Identifier";	
	
	/**
     * A key to look up a a named query FIND_BY_IDENTIFIER
     */
    public static final String FIND_BY_IDENTIFIER = "DocumentReceipt_Identifier";
    
    /**
     * A name of a param PARAM_IDENTIFIER
     */
    public static final String PARAM_IDENTIFIER = "identifier";
    
    /**
	 * A key to look up a a named query FIND_BY_VERSION
	 */
    public static final String FIND_BY_VERSION = "DocumentReceipt_Version";	

    public static final String PARAM_PERSON_VPID = "personVpid";

    public static final String PARAM_VERSION_NUMBER = "versionNumber";

    public List findHandbookListByPersonId(String personId) throws DAOException;
    public List findHandbookSendStatusListByPersonId(BigDecimal personId,BigDecimal handBookRelaseCtl) throws DAOException;
    public List lastHandbookReturnPostOffice(String personId) throws DAOException;
    public void insert(HandBookMailQueue handBookMailQueue) throws DAOException;
    public List getRawProfileData(String vpid, int receipt_id) throws DAOException;
    public List findHandbookTemplate() throws DAOException;

    public void recordDocumentAccess(DocumentAccessLog documentAccessLog) throws DAOException;
    //CCR 12155
    public List findDocumentAccessLog(BigDecimal fileId) throws DAOException;
   
    // using strutured query in hbm.xml file
    public HandBookMailQueue findHandBookByIdentifier(BigDecimal uid) throws DAOException;
    // merge
    public void merge(HandBookMailQueue handBookMailQueue) throws DAOException;
    // update
    public void update(HandBookMailQueue handBookMailQueue) throws DAOException; 
    // used to check if the handbook for the person alrady exit in send status.
    public List findHandBookEntryByPersonByTempOnSendStatus(BigDecimal personId,BigDecimal templId, BigDecimal statusTypeId,BigDecimal handBookRelaseCtl)throws DAOException;
   
    public List getHandBookMailQueueCountByBatchIdByStatus(BigDecimal batchRequestId, BigDecimal StatusTypeId) throws DAOException ;
    public List findAnyHandbookSentOrMailedForPersonId(String personId) throws DAOException;
    public List findDeliveryPreferenceEditableStatusByPersonId(String personId) throws DAOException;
   
    		
}
