package gov.va.med.esr.common.persistent.comms;

import gov.va.med.esr.common.model.comms.Directory;
import gov.va.med.esr.common.model.comms.DocumentReceipt;
import gov.va.med.fw.persistent.DAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.math.BigDecimal;
import java.util.List;

public interface DocumentReceiptDAO extends DAO{
	
	/**
     * A key to look up a a named query FIND_BY_IDENTIFIER
     */
    public static final String FIND_BY_IDENTIFIER = "DocumentReceipt_Identifier";
    
    /**
     * A name of a param PARAM_IDENTIFIER
     */
    public static final String PARAM_IDENTIFIER = "identifier";
    
    /**
	 * A key to look up a a named query FIND_BY_VERSION
	 */
	public static final String FIND_BY_VERSION = "DocumentReceipt_Version";	
	
	public static final String PARAM_PERSON_VPID = "personVpid";
	
	public static final String PARAM_VERSION_NUMBER = "versionNumber";
	
	
	public static final String PARAM_RECEIPT_STRING = "receiptString";
	
	/**
	 * A key to look up a a named query NAMED_QUERY_FIND_BY_PERSON
	 */
	public static final String FIND_BY_RECEIPT_STRING = "DocumentReceipt_findByReceiptString";
 
	/**
	 * A key to look up a a named query NAMED_QUERY_FIND_BY_PERSON
	 */
	public static final String FIND_BY_PERSON = "DocumentReceipt_All";
	
	public static final String FIND_ACTIVE_VBR_DIR = "findActiveVBADirectory";
    
	
	public void  setDao(DAOOperations dao);	
    
	public DocumentReceipt findDocumentReceiptById(BigDecimal requestId) throws DAOException;
	
	public DocumentReceipt findDocumentReceiptByVersion(String vpid,String versionNumber) throws DAOException;		
	
	public List findDocumentReceipts(String vpid) throws DAOException;
	
	/**
	 * find the list of document receipts sorted in receipt date descending order 
	 * @param vpid
	 * @return
	 * @throws DAOException
	 */
	public List findLatestDocumentReceipts(String vpid) throws DAOException;
	

	
	public DocumentReceipt findDocumentReceiptByReceiptString(String receiptString) throws DAOException;
    
	public Directory getActiveVBRDirectoty() throws DAOException;
	
	public void deleteDocumentReceipt(DocumentReceipt documentReceipt) throws DAOException;

}
